ledColor = rgbm(255/255, 0/255, 0/255, 255/255) -- goes from 0..1, divide by 255 if using regular conventions
ledFont = 'digital_big_italic'
maxBoost = 0
local function drawDualGauge(isStalled)
    if isStalled then
        display.text({
            text =  "---",
            pos = vec2(140,380),
            letter = vec2(70,150),
            font = ledFont,
            color = ledColor,
            alignment = 0.5,
            width = 270,
            spacing = -20
        })
    elseif car.extraD then
        display.text({
            text =  math.floor(car.waterTemperature),
            pos = vec2(140,380),
            letter = vec2(70,150),
            font = ledFont,
            color = ledColor,
            alignment = 0.5,
            width = 270,
            spacing = -20
        })
        display.text({
            text =  "c.",
            pos = vec2(215,427),
            letter = vec2(40,80),
            font = ledFont,
            color = ledColor,
            alignment = 0.5,
            width = 270,
            spacing = -10
        })
    else
        display.text({
            text =  math.floor(car.oilTemperature),
            pos = vec2(140,380),
            letter = vec2(70,150),
            font = ledFont,
            color = ledColor,
            alignment = 0.5,
            width = 270,
            spacing = -20
        })
        display.text({
            text =  "c",
            pos = vec2(200,427),
            letter = vec2(40,80),
            font = ledFont,
            color = ledColor,
            alignment = 0.5,
            width = 270,
            spacing = -20
        })
    end
end

local function drawMaxBoost(isStalled)
    maxBoost = math.max(maxBoost, math.floor(car.turboBoost*100)/100)
    if maxBoost == 0 or isStalled then
        display.text({
            text =  "---",
            pos = vec2(140,870),
            letter = vec2(70,150),
            font = ledFont,
            color = ledColor,
            alignment = 0.5,
            width = 270,
            spacing = -20
        })
    else
        display.text({
            text =  string.format("%.1f", maxBoost),
            pos = vec2(140,870),
            letter = vec2(70,150),
            font = ledFont,
            color = ledColor,
            alignment = 0.5,
            width = 270,
            spacing = -20
        })
    end
end

local function drawVoltage(voltage)
    if voltage == "---" then
        spacing = -20
    else
        spacing = -35
    end
    display.text({
        text =  voltage,
        pos = vec2(630,380),
        letter = vec2(70,150),
        font = ledFont,
        color = ledColor,
        alignment = 0.5,
        width = 270,
        spacing = spacing
    })
end

function script.update(dt)
    if (car.rpm < 50) then
        maxBoost = 0
        drawDualGauge(true)
        drawMaxBoost(true)
        drawVoltage("---")
    else
        drawDualGauge(false)
        drawMaxBoost(false)
        drawVoltage(string.format("%.1f", math.floor(car.batteryVoltage*10)/10))
    end
end