OrangeColor = rgb(0.59,0.51,0)

local function drawSpeed()
    setInterval(function ()
        currentSpeed = math.floor(car.speedKmh)
    end, 0.5, "key")

    clearInterval("key")

    display.text({
        text = currentSpeed,
        pos = vec2(25,120),
        letter = vec2(220,220),
        font = '996',
        color = OrangeColor,
        alignment = 1,
        width = 500,
        spacing = -70
      })
end

local function drawTrip()
    local integerNumber, floatNumber = math.modf(car.distanceDrivenSessionKm)
    display.text({
        text = math.min(999,string.format("%03d",integerNumber)),
        pos = vec2(148,542),
        letter = vec2(110,115),
        font = '996',
        color = OrangeColor,
        alignment = 1,
        width = 200,
        spacing = -22
    })
    display.text({
        text = ".",
        pos = vec2(187,538),
        letter = vec2(110,115),
        font = '996',
        color = OrangeColor,
        alignment = 1,
        width = 200,
        spacing = -22
    })
    display.text({
        text = math.min(9,math.floor(floatNumber*10)),
        pos = vec2(234,542),
        letter = vec2(110,115),
        font = '996',
        color = OrangeColor,
        alignment = 1,
        width = 200,
        spacing = -22
    })
end

local function drawOdo()
    display.text({
        text = math.min(99999,string.format("%05d",car.distanceDrivenTotalKm)),
        pos = vec2(252,400),
        letter = vec2(130,127),
        font = '996',
        color = OrangeColor,
        alignment = 1,
        width = 200,
        spacing = -43
    })
end

local function drawClock()
    display.text({
        text = sim.timeHours,
        pos = vec2(52,795),
        letter = vec2(130,127),
        font = '996',
        color = OrangeColor,
        alignment = 1,
        width = 200,
        spacing = -40
    })
    display.text({
        text = ":",
        pos = vec2(135,798),
        letter = vec2(130,121),
        font = '996',
        color = OrangeColor,
        alignment = 1,
        width = 200,
        spacing = -40
    })
    display.text({
        text = sim.timeMinutes,
        pos = vec2(264,795),
        letter = vec2(130,127),
        font = '996',
        color = OrangeColor,
        alignment = 1,
        width = 200,
        spacing = -40
    })
end

function script.update(dt)
    display.image{image = "theJ.png",pos = vec2(0,0),size = vec2(1024,1024) ,uvStart = vec2(0,0),uvEnd = vec2(1, 1)}
    drawSpeed()
    drawOdo()
    drawTrip()
    drawClock()
  end