sim = ac.getSim()

local gearsize = vec2(660, 580)
local gearpos = vec2(190, 493)
local gearsize2 = vec2(544, 464)
local gearpos2 = vec2(1440, 920)
local gearpos3 = vec2(70, 760)
local gearsize3 = vec2(435, 371)
local iconsize = vec2(165, 160)
local p1 = vec2(0, 0)
local s1 = vec2(0, 0)
local p2 = vec2(0, 0)
local s2 = vec2(0, 0)
local width1 = 46
local gear1 = "assets/1.dds"
local gear2 = "assets/2.dds"
local gear3 = "assets/3.dds"
local gear4 = "assets/4.dds"
local gear5 = "assets/5.dds"
local gear6 = "assets/6.dds"
local gearr = "assets/r.dds"
local gearn = "assets/n.dds"
local fontarial = "arial_big"
local rpmbar2 = "assets/rpm_bar_2.dds"
local battery = "assets/battery.dds"
local value = 0.0
local white = rgbm(1,1,1,1)
local green = rgbm(0,1,0,1)
local blue = rgbm(0,0,1,1)
local red = rgbm(1,0,0,1)
local black = rgbm(0,0,0,1)
local orange = rgbm(1,0.5,0,1)
local colfuel = rgbm(0.94, 0.62, 0.08, 1)

-- page 1 - racing display
local function modeA(dt)
    p1.x=0 p1.y=-1
    s1.x=2048 s1.y=2048
    display.image {
        image = "assets/page1.dds",
        pos = p1, -- coordinates of top left corner
        size = s1
    }
        -- gear display with real font loaded from pictures
    if car.gear == -1 then
        display.image {
            image = gearr,
            pos = gearpos,
            size = gearsize
        }
    elseif car.gear == 0 then
        display.image {
            image = gearn,
            pos = gearpos,
            size = gearsize
        }
    elseif car.gear == 1 then
        display.image {
            image = gear1,
            pos = gearpos,
            size = gearsize
        }
    elseif car.gear == 2 then
        display.image {
            image = gear2,
            pos = gearpos,
            size = gearsize
        }
    elseif car.gear == 3 then
        display.image {
            image = gear3,
            pos = gearpos,
            size = gearsize
        }
    elseif car.gear == 4 then
        display.image {
            image = gear4,
            pos = gearpos,
            size = gearsize
        }
    elseif car.gear == 5 then
        display.image {
            image = gear5,
            pos = gearpos,
            size = gearsize
        }
    elseif car.gear == 6 then
        display.image {
            image = gear6,
            pos = gearpos,
            size = gearsize
        }
    end
    -- battery icon
    if (car.batteryVoltage <= 9) then
        p1.x=1414 p1.y=872
        display.image {
            image = battery,
            pos = p1,
            size = iconsize,
            color = white
        }
    end
    -- oil pressure icon
    if (car.oilPressure <= 1) then
        p1.x=1412 p1.y=691
        display.image {
            image = "assets/oilp.dds",
            pos = p1,
            size = iconsize,
            color = white
        }
    end
    -- blinkers icons
    if (car.turningLeftLights and car.turningLightsActivePhase) then
      p1.x=1140 p1.y=510
      display.image {
        image = "assets/tl_left.dds",
            pos = p1,
            size = iconsize,
            color = white
        }
    end
    if (car.turningRightLights and car.turningLightsActivePhase) then
      p1.x=1690 p1.y=510
      display.image {
        image = "assets/tl_right.dds",
            pos = p1,
            size = iconsize,
            color = white
        }
    end
    -- headlights icon
    if (car.headlightsActive) then
          p1.x=1420 p1.y=508
          display.image {
            image = "assets/lights.dds",
            pos = p1,
            size = iconsize,
            color = white
        }
    end
    --speed text
    p1.x=260 p1.y=1110
    s1.x=100 s1.y=200
    display.text {
        text = string.format("%3d", math.floor(car.speedKmh)),
        pos = p1,
        letter = s1,
        font = fontarial,
        width = 1,
        alignment = -1.0,
        spacing = 0
      }

    -- fuel warning with overlay
    if (car.fuel <= 2) then
        p1.x=0 p1.y=1304
        s1.x=2048 s1.y=320
        display.rect {
            pos = p1,
            size = s1,
            color = colfuel
        }
        p1.x=420 p1.y=1400
        s1.x=70 s1.y=150
        display.text {
            text = "LOW FUEL PRESSURE",
            pos = p1,
            letter = s1,
            font = "arial_big",
            width = 46,
            alignment = 1,
            spacing = 5
        }
    else

      -- fuel display text
    p1.x=960 p1.y=1310
    s1.x=75 s1.y=150
    display.text {
        text = string.format("%2.1f", car.fuel),
        pos = p1,
        letter = s1,
        font = fontarial,
        width = width1,
        alignment = 1,
        spacing = -15
      }
      -- engine map mode text
      p1.x=650 p1.y=1310
      s1.x=75 s1.y=150
      display.text {
        text = string.format(car.fuelMap+1),
        pos = p1,
        letter = s1,
        font = fontarial,
        width = width1,
        alignment = 1,
        spacing = -15
      }

      -- lap counter
      p1.x=220 p1.y=1460
      s1.x=90 s1.y=180
      display.text {
          text = string.format('%2d', car.lapCount),
          pos = p1,
          letter = s1,
          font = fontarial,
          width = width1,
          alignment = 0.5,
          spacing = 0
      }

    -- last lap text
    local time = car.previousLapTimeMs
    local formattedTime =
    string.format(
      "%02d:%02d:%02d",
      math.floor((time / (1000 * 60))) % 60,
      math.floor((time / 1000)) % 60,
      math.floor((time % 1000) / 10)
    )
    p1.x=480 p1.y=1520
    s1.x=60 s1.y=120
    display.text {
        text = formattedTime,
        pos = p1,
        letter = s1,
        font = fontarial,
        width = width1,
        alignment = 1,
        spacing = -10
    }

    -- best lap text
    local time = car.bestLapTimeMs
    local formattedTime =
    string.format(
      "%02d:%02d:%02d",
      math.floor((time / (1000 * 60))) % 60,
      math.floor((time / 1000)) % 60,
      math.floor((time % 1000) / 10)
  )
  p1.x=950 p1.y=1520
  s1.x=60 s1.y=120
  display.text {
        text = formattedTime,
        pos = p1,
        letter = s1,
        font = fontarial,
        width = width1,
        alignment = 1,
        spacing = -10
    }

    -- delta performance
    -- local time = car.estimatedLapTimeMs
    local perfDiffSpeedDiff = car.performanceMeterSpeedDifferenceMs
    local diff = perfDiffSpeedDiff/8 * 262 -- can be minus
    if diff >263 then
      diff = 263
    elseif diff < -263 then
      diff = -263
    end
    -- ac.debug("diff", string.format('%.3f', diff))
    -- 1455,1338;263x62 red
    -- 1724,1338;263x62 green
    local x = 1724
    local color1 = white
    if perfDiffSpeedDiff>=0.0 then
      color1 = green -- green
    else
      x = 1455 + 262
      color1 = red -- red
    end
    p1.x=x p1.y=1338
    s1.x=diff s1.y=62
    display.rect {
        pos = p1,    -- coordinates of top left corner
        size = s1,  -- drawing backwards when diff is negative
        color = color1
    }

    local perfMeter = car.performanceMeter
    local formattedTime = string.format('%+.2f', perfMeter)
    p1.x=1590 p1.y=1520
    s1.x=60 s1.y=120
    display.text {
        text = formattedTime,
        pos = p1,
        letter = s1,
        font = "arial_big",
        width = 46,
        alignment = 1,
        spacing = -10,
        -- color = color1    -- time also colored?
        color = white
    }
    end

end

-- page 2 - brake balance screen
local function modeB(dt)
    p1.x=0 p1.y=-1
    s1.x=2048 s1.y=2048
    display.image {
        image = "assets/page2.dds",
        pos = p1,
        size = s1
    }
         -- page 2 RPM gauge
    value = math.saturate(car.rpm / 8000)
    p1.x=58 p1.y=527
    s1.x=2020 * value s1.y=466
    p2.x=0 p2.y=0
    s2.x=value s2.y=1
    display.image {
        image = rpmbar2,
        pos = p1,
        size = s1,
        uvStart = p2,
        uvEnd = s2,
    }
    -- brake balance gauge
    value = math.saturate(car.brakeBias)
    p1.x=619 p1.y=1390
    s1.x=713 * value s1.y=159
    display.image {
        image = "assets/bbal_gauge.dds",
        pos = p1,
        size = s1,
        uvStart = p2,
        uvEnd = s2,
    }
    -- brake balance text
    p1.x=720 p1.y=1160
    s1.x=120 s1.y=240
    display.text {
        text = string.format("%2.0f", car.brakeBias * 100),
        pos = p1,
        letter = s1,
        font = fontarial,
        width = width1,
        alignment = 1,
        spacing = -15
    }
    -- brake pressure gauge front
    p1.x=126 p1.y=1557
    s1.x=101 s1.y=-value*514
    p2.x=0 p2.y=0
    s2.x=1 s2.y=1
    value = math.saturate(0.7 + (car.brakeBias - 0.5))
    display.rect {
        pos = p1,
        size = s1,
        color = white,
        uvStart = p2,
        uvEnd = s2
      }
    -- brake pressure gauge rear
    value = math.saturate(0.7 - (car.brakeBias - 0.5))
    p1.x=358 p1.y=1557
    s1.x=101 s1.y=-value*514
    p2.x=0 p2.y=0
    s2.x=1 s2.y=1
    display.rect {
      pos = p1,
      size = s1,
      color = white,
      uvStart = p2,
      uvEnd = s2
    }
        -- gear display with real font loaded from pictures
        if car.gear == -1 then
            display.image {
                image = gearr,
                pos = gearpos2,
                size = gearsize2
            }
        elseif car.gear == 0 then
            display.image {
                image = gearn,
                pos = gearpos2,
                size = gearsize2
            }
        elseif car.gear == 1 then
            display.image {
                image = gear1,
                pos = gearpos2,
                size = gearsize2
            }
        elseif car.gear == 2 then
            display.image {
                image = gear2,
                pos = gearpos2,
                size = gearsize2
            }
        elseif car.gear == 3 then
            display.image {
                image = gear3,
                pos = gearpos2,
                size = gearsize2
            }
        elseif car.gear == 4 then
            display.image {
                image = gear4,
                pos = gearpos2,
                size = gearsize2
            }
        elseif car.gear == 5 then
            display.image {
                image = gear5,
                pos = gearpos2,
                size = gearsize2
            }
        elseif car.gear == 6 then
            display.image {
                image = gear6,
                pos = gearpos2,
                size = gearsize2
            }
        end

end

local function modeC(dt) -- page 3 - pit limiter screen
    p1.x=0 p1.y=-1
    s1.x=2048 s1.y=2048
    display.image {
        image = "assets/page3.dds",
        pos = p1,
        size = s1
    }
        -- gear display
    local gearText = tostring(car.gear) -- needs to be converted so that neutral and reverse display correctly (-1 = R, 0 = N)
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    -- Pit limiter ON/OFF icons

	 if (car.speedLimiter > 0) then
        p1.x=1445 p1.y=736
        s1.x=548 s1.y=234
        display.image {
            image = "assets/pit_on.dds",
            pos = p1,
            size = s1
            }
    else
        p1.x=1445 p1.y=736
        s1.x=548 s1.y=234
        display.image {
            image = "assets/pit_off.dds",
            pos = p1,
            size = s1
        }
    end
    -- pit limiter speed text
    p1.x=840 p1.y=1160
    s1.x=200 s1.y=400
    display.text {
        text = string.format(car.speedLimiter),
        pos = p1,
        letter = s1,
        font = fontarial,
        width = width1,
        alignment = 1,
        spacing = -15
    }

end

local function modeD(dt) -- page 4 - launch control
    p1.x=0 p1.y=-1
    s1.x=2048 s1.y=2048
    display.image {
        image = "assets/page4.dds",
        pos = p1, -- coordinates of top left corner
        size = s1
    }

    -- rainbow rpm gauge at launch control
    value = math.saturate(car.rpm / 8000) -- saturate clamps value between 0 and 1
    p1.x=46 p1.y=426
    s1.x=1969*value s1.y=198
    p2.x=0 p2.y=0
    s2.x=value s2.y=1
    display.image {
        image = "assets/rpm_bar_1.dds",
        pos = p1,
        size = s1,
        uvStart = p2,
        uvEnd = s2
    }
    -- turbo presure text
    p1.x=905 p1.y=860
    s1.x=50 s1.y=100
    display.text {
        text = string.format("%3.0f", car.turboBoost * 1000),
        --text = string.format("%3d", math.tointeger( car.turboBoost * 1000) ),
        pos = p1,
        letter = s1,
        font = fontarial,
        width = width1,
        alignment = 1,
        spacing = -10,
        color = orange
    }
    -- turbo pressure gauge
    local value = math.saturate(car.turboBoost / 3)
    p1.x=556 p1.y=945
    s1.x=645*value s1.y=109
    p2.x=0 p2.y=0
    s2.x=value s2.y=1
    display.image {
        image = "assets/turbo.dds",
        pos = p1,
        size = s1,
        uvStart = p2,
        uvEnd = s2
    }
    -- throttle bar
    local value = math.saturate(car.gas)
    p1.x=1822 p1.y=1522
    s1.x=62 s1.y=-value*572
    p2.x=0 p2.y=0
    s2.x=value s2.y=1
    display.rect {
        pos = p1,
        size = s1,
        color = green,
        uvStart = p2,
        uvEnd = s2
    }
    -- brake bar
    local value = math.saturate(car.handbrake)
    p1.x=1574 p1.y=1522
    s1.x=63 s1.y=-value*572
    p2.x=0 p2.y=0
    s2.x=1 s2.y=1
    display.rect {
      pos = p1,
      size = s1,
      color = red,
      uvStart = p2,
      uvEnd = s2
  }
    -- clutch bar
    local value = math.saturate(1 - car.clutch)
    p1.x=1348 p1.y=1522
    s1.x=63 s1.y=-value*572
    p2.x=0 p2.y=0
    s2.x=1 s2.y=1
    display.rect {
        pos = p1,
        size = s1,
        color = blue,
        uvStart = p2,
        uvEnd = s2
      }
    -- ready warning
    if (car.clutch <= 0.8) and (car.handbrake >= 0.8) and (car.gear == 1) then
        p1.x=557 p1.y=1150
        s1.x=640 s1.y=250
        display.rect {
            pos = p1,
            size = s1,
            color = green
            }
         display.text {
            text = "READY",
             pos = vec2(720, 1230),
            letter = vec2(75, 150),
            font = fontarial,
            width = width1,
            alignment = 1,
            spacing = -5,
            color = black
            }
    else
      p1.x=557 p1.y=1150
      s1.x=640 s1.y=250
      display.rect {
          pos = p1,
          size = s1,
          color = red
          }
      p1.x=574 p1.y=1230
      s1.x=65 s1.y=130
      display.text {
            text = "NOT READY",
            pos = p1,
            letter = s1,
            font = fontarial,
            width = width1,
            alignment = 1,
            spacing = 2
      }

    end
     -- gear display with real font loaded from pictures
     if car.gear == -1 then
        display.image {
            image = gearr,
            pos = gearpos3,
            size = gearsize3
        }
    elseif car.gear == 0 then
        display.image {
            image = gearn,
            pos = gearpos3,
            size = gearsize3
        }
    elseif car.gear == 1 then
        display.image {
            image = gear1,
            pos = gearpos3,
            size = gearsize3
        }
    elseif car.gear == 2 then
        display.image {
            image = gear2,
            pos = gearpos3,
            size = gearsize3
        }
    elseif car.gear == 3 then
        display.image {
            image = gear3,
            pos = gearpos3,
            size = gearsize3
        }
    elseif car.gear == 4 then
        display.image {
            image = gear4,
            pos = gearpos3,
            size = gearsize3
        }
    elseif car.gear == 5 then
        display.image {
            image = gear5,
            pos = gearpos3,
            size = gearsize3
        }
    elseif car.gear == 6 then
        display.image {
            image = gear6,
            pos = gearpos3,
            size = gearsize3
        }
    end
     -- last lap gauge
    local time = car.lapTimeMs
    local formattedTime =
        string.format(
        "%02d:%02d:%03d",
        math.floor((time / (1000 * 60))) % 60,
        math.floor((time / 1000)) % 60,
        math.floor((time % 1000) / 100)
    )
    p1.x=60 p1.y=1230
    s1.x=65 s1.y=130
    display.text {
        text = formattedTime,
        pos = p1,
        letter = s1,
        font = fontarial,
        width = width1,
        alignment = 1,
        spacing = -12
    }
end

-- display switch
local listOfModes = {modeA, modeB, modeC, modeD} -- 4 displays cycle
local currentMode = tonumber(ac.loadDisplayValue("displayMode", "1")) or 1
local prevMode    = currentMode
local lastExtraAState = false
local lastExtraFState = false
local lastBrakeBlance = car.brakeBias or 0.0
local lastPitLimiterOn = car.manualPitsSpeedLimiterEnabled or false
local brakebiasTimer = 0.0
local pitLimiterTimer = 0.0
local lcOn = false

function script.update(dt)

    if brakebiasTimer > 0.0 then
        brakebiasTimer = brakebiasTimer - dt
        if brakebiasTimer<=0.0 then
            currentMode = prevMode
            lastBrakeBlance = car.brakeBias or 0.0
        end
    end

    if pitLimiterTimer > 0.0 then
        pitLimiterTimer = pitLimiterTimer - dt
        if pitLimiterTimer<=0.0 then
            currentMode = prevMode
            lastPitLimiterOn = car.manualPitsSpeedLimiterEnabled or false
        end
    end

    if car.extraF ~= lastExtraFState then
        if lcOn ~= true then
            prevMode = currentMode
        end
        lcOn = true
        currentMode = 4
    else
        if lcOn then
            currentMode = prevMode
            lastExtraFState = false
            lcOn = false
        end
        if car.extraA ~= lastExtraAState then
            lastExtraAState = car.extraA
            currentMode = currentMode + 1
            if currentMode > #listOfModes then
              currentMode = 1
            end
            ac.saveDisplayValue("displayMode", tostring(currentMode))
        elseif lastBrakeBlance ~= car.brakeBias and brakebiasTimer <= 0.0 then
            lastBrakeBlance = car.brakeBias or 0.0
            prevMode = currentMode
            currentMode = 2
            brakebiasTimer = 4.0

        elseif lastPitLimiterOn ~= car.manualPitsSpeedLimiterEnabled and pitLimiterTimer <= 0.0 then
            lastPitLimiterOn = car.manualPitsSpeedLimiterEnabled or false
            prevMode = currentMode
            currentMode = 3
            pitLimiterTimer = 2.0
        end
    end

    -- ac.debug("Current Page", currentMode)
    -- ac.debug("lastBrakeBlance", lastBrakeBlance)

    --- finally set active
    
   -- currentMode=1
    listOfModes[currentMode](dt)
end
