

Config = {
    powertune = {
        -- config options for ADU5
        ShiftWarn = 80 -- % of RPM (of Limiter) when RPM Bar should turn Red
    }
}

sim = ac.getSim()
SmoothedAccel = {x = 0, z = 0} -- global default value definition for x and z axis of vec() car.acceleration.

function modeA(dt)
	-- grey background for second screen, draws on top of mesh texture so pay attention to transparency, might need layering depending on what youre doing
    display.rect {
        pos = vec2(0, 0), 
        size = vec2(000, 00),
        color = rgbm(0.55, 0.55, 0.55, 1)
    
   }


    -- actual background for second screen, last in line since script runs top to bottom and transparency layer needs to be at the very top of the stack
    display.image {
        image = "assets/screen.dds",
        pos = vec2(0, 0), -- coordinates of top left corner
        size = vec2(1024, 1024)    
  }
	    display.text {
        text = string.format("%.1f", car.oilPressure),
        pos = vec2(70, 315),
        letter = vec2(50, 60),
        font = "c7_new",
        width = 1,
        alignment = 10,
        spacing = -5,
        color = rgbm(10, 10, 10, 1)

  }
	    display.text {
        text = string.format("%.1f", car.oilTemperature),
        pos = vec2(50, 130),
        letter = vec2(50, 60),
        font = "c7_new",
        width = 1,
        alignment = 10,
        spacing = -5,
        color = rgbm(10, 10, 10, 1)
   
   }
    display.text {
        text = string.format("%.1f", car.waterTemperature),
        pos = vec2(785, 130),
        letter = vec2(50, 60),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -05,
        color = rgbm(10, 10, 10, 1)
    }


    display.text {
        text = string.format("%.1f", car.batteryVoltage),
        pos = vec2(50, 500),
        letter = vec2(50, 60),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -05,
        color = rgbm(10, 10, 10, 1)
  
 }

   display.text {
        text = string.format("%.1f", car.fuel),
        pos = vec2(50, 675),
        letter = vec2(50, 60),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -05,
        color = rgbm(10, 10, 10, 1)
  
 }

  
 display.text {
        text = string.format("%.1f", car.turboBoost),
        pos = vec2(810, 680),
        letter = vec2(50, 50),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -05,
        color = rgbm(10, 10, 10, 1)

    

    }


    -- Gear display
    local gearText = tostring(car.gear) -- needs to be converted so that neutral and reverse display correctly (-1 = R, 0 = N)
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    display.text {
        text = gearText,
        pos = vec2(330, 212),
        letter = vec2(350, 390),
        font = "mclarenmp4gt3",
        width = 46,
        alignment = 1,
        spacing = 0
    }

 -- TPS gauge
    display.text {
        text = string.format("%d", car.gas * 100),
        pos = vec2(725, 350),
        letter = vec2(100, 110),
        font = "mclarenmp4gt3",
        color = rgbm(1,1,1,1),
        width = 2,
        alignment = 1,
        spacing = -2
    }

	-- speed gauge (with formatting for correct digit positions with additional digits appearing)
    digitCoords = {
        -- define your coords here
        vec2(425, 120), -- the leftmost digit
        vec2(475, 120), -- the center digit
        vec2(520, 120) -- the rightmost digit
    }
    -- preparing our table of speed digits
    local displayspeed = tostring(math.floor(car.poweredWheelsSpeed)) -- math.floor rounds to the next full number
    local speedTable = {}
    for i = 1, string.len(displayspeed) do
        speedTable[i] = displayspeed:sub(i, i)
    end
    if string.len(displayspeed) == 1 then
        display.text {
            -- rightmost digit
            text = speedTable[1],
            pos = digitCoords[3],
            letter = vec2(50, 100),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = -1.0,
            color = rgbm(1, 1, 1, 1)
        }
    elseif string.len(displayspeed) == 2 then
        display.text {
            -- rightmost digit
            text = speedTable[2],
            pos = digitCoords[3],
            letter = vec2(50, 100),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = -1.0,
            color = rgbm(1, 1, 1, 1)
        }
        display.text {
            -- center digit
            text = speedTable[1],
            pos = digitCoords[2],
            letter = vec2(50, 100),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = -1.0,
            color = rgbm(1, 1, 1, 1)
        }
    elseif string.len(displayspeed) == 3 then
        display.text {
            -- rightmost digit
            text = speedTable[3],
            pos = digitCoords[3],
            letter = vec2(50, 100),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = -1.0,
            color = rgbm(1, 1, 1, 1)
        }
        display.text {
            -- center digit
            text = speedTable[2],
            pos = digitCoords[2],
            letter = vec2(50, 100),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = -1.0,
            color = rgbm(1, 1, 1, 1)
        }
        display.text {
            -- leftmost digit
            text = speedTable[1],
            pos = digitCoords[1],
            letter = vec2(50, 100),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = -1.0,
            color = rgbm(1, 1, 1, 1)
        }
    end
		digitCoords = {
        -- define your coords here
        vec2(420, 700), --left quad
        vec2(440, 700), --left triple
        vec2(460, 700), --left dual
        vec2(480, 700), --center
        vec2(500, 700), --right dual
        vec2(520, 700),--right triple    
        vec2(540, 700) --right quad
    }
    -- preparing our table of rpm digits
    local displayrpm = tostring(math.floor(car.rpm))
    local rpmTable = {}
    for i = 1, string.len(displayrpm) do
        rpmTable[i] = displayrpm:sub(i, i)
    end
    if string.len(displayrpm) == 1 then
        display.text {
            -- rightmost digit
            text = rpmTable[1],
            pos = digitCoords[4],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
    elseif string.len(displayrpm) == 2 then
        display.text {
            -- rightmost digit
            text = rpmTable[2],
            pos = digitCoords[5],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
        display.text {
            -- leftmost digit
            text = rpmTable[1],
            pos = digitCoords[3],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
    elseif string.len(displayrpm) == 3 then
        display.text {
            -- rightmost digit
            text = rpmTable[3],
            pos = digitCoords[6],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
        display.text {
            -- center digit
            text = rpmTable[2],
            pos = digitCoords[4],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
        display.text {
            -- leftmost digit
            text = rpmTable[1],
            pos = digitCoords[2],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
    elseif string.len(displayrpm) == 4 then
        display.text {
            -- rightmost digit
            text = rpmTable[4],
            pos = digitCoords[7],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
        display.text {
            -- center digit
            text = rpmTable[3],
            pos = digitCoords[5],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
        display.text {
            -- leftmost digit
            text = rpmTable[2],
            pos = digitCoords[3],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
        display.text {
            -- leftmost digit
            text = rpmTable[1],
            pos = digitCoords[1],
            letter = vec2(50, 50),
            font = "c7_new",
            width = 16,
            spacing = 0,
            alignment = 1.0
        }
    end

   

  
end	

-- didplay switch
local listOfModes = {modeA, modeB, modeC} -- you can add infinite displays, their elements need to be inside function modeN(dt)
local currentMode = tonumber(ac.loadDisplayValue("displayMode", 1))
local lastExtraCState = false

function update(dt)
    ac.debug("Update Delta", dt)
    if car.extraC ~= lastExtraCState then -- switching is bound to extraC key, this tracks the state of extraC
        currentMode = currentMode + 1 -- you start at mode 1 and each extraC press adds +1 to the mode count
        if currentMode > #listOfModes then -- as soon as your mode counter exceeds the number of modes inside listOfModes it defaults back to mode 1
            currentMode = 1 -- should be the same as local currentMode =
        end
        ac.saveDisplayValue("displayMode", currentMode)
    end
    ac.debug("Current Page", currentMode)
    lastExtraCState = car.extraC
    listOfModes[currentMode](dt)
end

