local bootup = ui.MediaPlayer()
bootup:setSource('assets/bootup.mp4'):setAutoPlay(true)

function Motec ()

    display.image {
        image = "assets/Motec_Erebus.dds",
        pos = vec2(0,0),
        size = vec2(859, 480)
    }
end

function text ()

    display.text {
        text = string.format("%d", car.brake * 100),
        pos = vec2(625, 290),
        letter = vec2(60, 70),
        font = "bosch",
        color = rgbm(1,0,0,1),
        width = 46,
        alignment = 1,
        spacing = -25
    }

    display.text {
        text = string.format("%d", car.lapCount),
        pos = vec2(144, 100),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -25
    }

    display.text {
        text = string.format("%.1f", ac.getCar().brakeBias * 100),
        pos = vec2(625, 100),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -21
    }

    display.text {
        text = string.format("%d", car.rpm),
        pos = vec2(374, 240),
        letter = vec2(40, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

    display.text {
        text = string.format("%d", car.racePosition),
        pos = vec2(130, 390),
        letter = vec2(40, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

	    local color
	if car.performanceMeter > 0 then
    	color = rgbm(1, 0, 0, 1) 
	elseif car.performanceMeter < 0 then
    	color = rgbm(0, 1, 0, 1) 
	else
   	    color = rgbm(1, 1, 1, 1) 
	end

	display.text {
   	 text = string.format("%.2f", car.performanceMeter), 
   	 pos = vec2(355, 380),
   	 letter = vec2(50, 60),
   	 font = "bosch",
   	 color = color, 
   	 width = 35,
   	 alignment = 1,
   	 spacing = -15
	}

    display.text {
        text = string.format("%d", car.fuel),
        pos = vec2(140, 205),
        letter = vec2(40, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

display.text {
    text = string.format("%02d:%02d.%03d", 
        math.floor(car.bestLapTimeMs / 60000),        
        math.floor((car.bestLapTimeMs % 60000) / 1000), 
        car.bestLapTimeMs % 1000                      
    ),
    pos = vec2(320, 330),
    letter = vec2(40, 50),
    font = "bosch",
    color = rgbm(1, 1, 1, 1),
    width = 46,
    alignment = 1,
    spacing = -15
}

    display.text {
        text = string.format("%.f", car.waterTemperature),
        pos = vec2(702, 410),
        letter = vec2(20, 30),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -8
    }

    display.text {
        text = string.format("%.1f", car.oilPressure),
        pos = vec2(700, 363),
        letter = vec2(20, 30),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -8
    }

    display.text {
        text = string.format("%d", car.oilTemperature),
        pos = vec2(660, 387),
        letter = vec2(20, 30),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -8
    }

    display.text {
        text = string.format("%d", car.gas * 100),
        pos = vec2(625, 190),
        letter = vec2(60, 70),
        font = "bosch",
        color = rgbm(0,1,0,1),
        width = 46,
        alignment = 1,
        spacing = -20
    }

    display.text {
        text = string.format("%.1f", car.batteryVoltage), 
        pos = vec2(720, 432),
        letter = vec2(20, 30),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -8
    }

    display.text {
        text = string.format("%d", car.speedKmh), 
        pos = vec2(124, 300),
        letter = vec2(40, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

    local gearText = tostring(car.gear) 
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    display.text {
        text = gearText,
        pos = vec2(360, 62),
        letter = vec2(140, 180),
        font = "bosch",
        width = 70,
        alignment = 1,
        spacing = 0
    }
end


function images()

    if (car.engineLifeLeft <= 600) then
        display.image {
            image = "assets/egm.dds",
            pos = vec2(666, 9), 
            size = vec2(37, 23)
        }
    end

    if (car.headlightsActive == true) then
        display.image {
            image = "assets/lights.dds",
            pos = vec2(610, 9), 
            size = vec2(37, 23)
        }
    end

    if (car.oilPressure <= 1) then
        display.image {
            image = "assets/oil.dds",
            pos = vec2(780, 9), 
            size = vec2(37, 23)
        }
    end

    if (car.handbrake == 1) then
        display.image {
            image = "assets/pbrake.dds",
            pos = vec2(226, 9), 
            size = vec2(28, 23)
        }
    end

    if (car.fuel <= 5) then
        display.image {
            image = "assets/gas.dds",
            pos = vec2(560, 9), 
            size = vec2(37, 23)
        }
    end
end

function Overrev ()
    if (car.rpm >= 8000) then
        display.image {
          image = 'assets/revwarning.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Pitlimiter ()
    if (car.manualPitsSpeedLimiterEnabled == true) then
        display.image {
          image = 'assets/pitlimiter.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Black_Orange ()
    if sim.raceFlagType == ac.FlagType.ReturnToPits then
        display.image {
            image = 'assets/Penalty.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Finish ()
    if sim.raceFlagType == ac.FlagType.Finished then
        display.image {
            image = 'assets/Checkeredflag.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Caution ()
    if sim.raceFlagType == ac.FlagType.Caution then
        display.image {
            image = 'assets/Caution.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Blue ()
    if sim.raceFlagType == ac.FlagType.FasterCar then
        display.image {
            image = 'assets/Yourslow.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end


function script.update(dt)
    if (bootup:ended()) then
        Motec()
        text()
        images()
        Overrev()
        Pitlimiter()
        Blue()
        Caution()
        Finish()
        Black_Orange()
    else
        ui.drawImage(bootup, vec2(), vec2(859, 480))
    end
end