local bootup = ui.MediaPlayer()
bootup:setSource('assets/bootup.mp4'):setAutoPlay(true)

function Motec ()

    display.image {
        image = "assets/Motec_BJR.dds",
        pos = vec2(0,0),
        size = vec2(859, 480)
    }
end

function text ()
    
    display.text {
        text = string.format("%d", car.brake * 100),
        pos = vec2(547, 70),
        letter = vec2(40, 40),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -15
    }

    display.text {
        text = string.format("%.1f", ac.getCar().brakeBias * 100),
        pos = vec2(45, 250),
        letter = vec2(60, 70),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -30
    }

    display.text {
        text = string.format("%d", car.rpm),
        pos = vec2(255, 295),
        letter = vec2(40, 40),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

    display.text {
        text = string.format("%d", car.racePosition),
        pos = vec2(585, 400),
        letter = vec2(60, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -20
    }

    local color
if car.performanceMeter > 0 then
    color = rgbm(1, 0, 0, 1) 
elseif car.performanceMeter < 0 then
    color = rgbm(0, 1, 0, 1) 
else
    color = rgbm(1, 1, 1, 1) 
end

display.text {
    text = string.format("%.3f", car.performanceMeter), 
    pos = vec2(500, 120),
    letter = vec2(80, 80),
    font = "bosch",
    color = color, 
    width = 35,
    alignment = 1,
    spacing = -37
}

    display.text {
        text = string.format("%d", car.fuel),
        pos = vec2(65, 90),
        letter = vec2(60, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -25
    }

    display.text {
        text = string.format("%.2f", car.fuel / car.fuelPerLap),
        pos = vec2(170, 400),
        letter = vec2(60, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

display.text {
    text = string.format("%02d:%02d.%03d", 
        math.floor(car.bestLapTimeMs / 60000),
        math.floor((car.bestLapTimeMs % 60000) / 1000),
        car.bestLapTimeMs % 1000
    ),
    pos = vec2(450, 280),
    letter = vec2(40, 50),
    font = "bosch",
    color = rgbm(3,0,3,5),
    width = 35,
    alignment = 1,
    spacing = -10
}

display.text {
    text = string.format("%02d:%02d.%03d", 
        math.floor(car.previousLapTimeMs / 60000),
        math.floor((car.previousLapTimeMs % 60000) / 1000),
        car.previousLapTimeMs % 1000
    ),
    pos = vec2(450, 210),
    letter = vec2(40, 50),
    font = "bosch",
    color = rgbm(1,1,1,1),
    width = 35,
    alignment = 1,
    spacing = -10
}

    display.text {
        text = string.format("%d", car.gas * 100),
        pos = vec2(355, 70),
        letter = vec2(40, 40),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -15
    }

    display.text {
        text = string.format("%d", car.speedKmh),
        pos = vec2(249, 255),
        letter = vec2(50, 50),
        font = "bosch",
        color = rgbm(1,1,0,1),
        width = 46,
        alignment = 1,
        spacing = -10
    }

    local gearText = tostring(car.gear)
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    display.text {
        text = gearText,
        pos = vec2(240, 100),
        letter = vec2(140, 180),
        font = "bosch",
        width = 70,
        alignment = 1,
        spacing = 0
    }
end

function images()

   
    if (car.batteryVoltage <= 11) then
        display.image {
            image = "assets/battery.dds",
            pos = vec2(700, 9), 
            size = vec2(37, 23)
        }
    end

    if (car.engineLifeLeft <= 600) then
        display.image {
            image = "assets/egm.dds",
            pos = vec2(770, 9), 
            size = vec2(37, 23)
        }
    end

    if (car.headlightsActive == true) then
        display.image {
            image = "assets/lights.dds",
            pos = vec2(630, 9), 
            size = vec2(37, 23)
        }
    end

    if (car.oilPressure <= 1) then
        display.image {
            image = "assets/oil.dds",
            pos = vec2(630,9),
            size = vec2(37,23)
        }
    end

    if (car.handbrake == 1) then
        display.image {
            image = "assets/pbrake.dds",
            pos = vec2(226, 9), 
            size = vec2(37, 23)
        }
    end

    if (car.fuel <= 5) then
        display.image {
            image = "assets/gas.dds",
            pos = vec2(560, 9), 
            size = vec2(37,23)
        }
    end
end

function Overrev ()
    if (car.rpm >= 8000) then
        display.image {
          image = 'assets/revwarning.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Second_Light()
    local flash_speed = 0.1  
    local time = os.clock()  
    
    if (car.rpm >= 7000) then
        if math.floor(time / flash_speed) % 2 == 0 then
            display.image {
                image = 'assets/red_rev.dds',
                pos = vec2(475, 35),
                size = vec2(40, 40)
            }
        end
    end
end


function First_Light ()
    if (car.rpm >= 4500) then
        display.image {
          image = 'assets/green_rev.dds',
          pos = vec2(350,35),
        size = vec2(40, 40)
        }
    end
end

function Third_Light()
    if (car.rpm >= 5500) then
        display.image {
          image = 'assets/green_rev_2.dds',
          pos = vec2(390,35),
        size = vec2(40, 40)
        }
    end
end

function Fourth_Light()
    if (car.rpm >= 6800) then
        display.image {
          image = 'assets/green_rev_3.dds',
          pos = vec2(430,35),
        size = vec2(40, 40)
        }
    end
end

function Pitlimiter ()
    if (car.manualPitsSpeedLimiterEnabled == true) then
        display.image {
          image = 'assets/pitlimiter.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Black_Orange ()
    if sim.raceFlagType == ac.FlagType.ReturnToPits then
        display.image {
            image = 'assets/Penalty.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Finish ()
    if sim.raceFlagType == ac.FlagType.Finished then
        display.image {
            image = 'assets/Checkeredflag.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Caution ()
    if sim.raceFlagType == ac.FlagType.Caution then
        display.image {
            image = 'assets/Caution.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Blue ()
    if sim.raceFlagType == ac.FlagType.FasterCar then
        display.image {
            image = 'assets/Yourslow.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end


function script.update(dt)
    if (bootup:ended()) then
        Motec()
        text()
        images()
        Overrev()
        Pitlimiter()
        Blue()
        Caution()
        Finish()
        Black_Orange()
        Second_Light()
        First_Light()
		Third_Light()
		Fourth_Light()
    else
        ui.drawImage(bootup, vec2(), vec2(859, 480))
    end
end


