package.add("src")
require("utils")

local round = math.round
local floor = math.floor
local ceil = math.ceil
local applyLag = math.applyLag

local sim = ac.getSim()

local ext_car = ac.connect({
	ac.StructItem.key(ac.getCarID(car.index) .. "_ext_car_" .. car.index),
	connected = ac.StructItem.boolean(),
	oilTemperature = ac.StructItem.float(),
	antirollBarFrontPosition = ac.StructItem.int16(),
	antirollBarRearPosition = ac.StructItem.int16(),
	brakeBiasPosition = ac.StructItem.int16(),
	isIgnitionOn = ac.StructItem.boolean(),
	isElectronicsBooted = ac.StructItem.boolean(),
	isStarterCranking = ac.StructItem.boolean(),
	isEngineStarted = ac.StructItem.boolean(),
	isEngineRunning = ac.StructItem.boolean(),
}, true, ac.SharedNamespace.CarScript)

local slowestRefreshPeriod = 0.3
local slowRefreshPeriod = 0.15
local fastRefreshPeriod = 0.075

local fdata = {
	fuelPressure = 56.8,
}

local delaySlowest = slowestRefreshPeriod
local delaySlow = slowRefreshPeriod
local delayFast = fastRefreshPeriod

local function slowestRefreshData(dt)
	delaySlowest = 0

	fdata.lapCount = car.lapCount + 1
	fdata.previousLapTimeMs = car.previousLapTimeMs
	fdata.isInPitlane = car.isInPitlane
	fdata.fuel = car.fuel
	fdata.oilPressure = car.oilPressure * 14.5038 * 10
	fdata.batteryVoltage = ceil(car.batteryVoltage * 10) / 10
	fdata.brakeBias = car.brakeBias * 1000
	fdata.fuelPressure = ceil(applyLag(fdata.fuelPressure, 50 + car.rpm / 1000, 0.9, dt) * 10) / 10
	fdata.oilTemperature = round(ext_car.oilTemperature)
	fdata.waterTemperature = round(car.waterTemperature)
	fdata.lapTimeMs = car.lapTimeMs
end

local function slowRefreshData(dt)
	delaySlow = 0
	fdata.gear = car.gear
	if fdata.gear == 0 then
		fdata.gear = "N"
	elseif fdata.gear == -1 then
		fdata.gear = "R"
	end

	fdata.speedKmh = round(car.speedKmh)
	fdata.performanceMeter = car.performanceMeter
end

local function fastRefreshData(dt)
	delayFast = 0
	fdata.rpm = (car.rpm < 50) and 0 or round(car.rpm)
end

local function fastestRefreshData(dt)
	fdata.isIgnitionOn = ext_car.isIgnitionOn
	fdata.isElectronicsBooted = ext_car.isElectronicsBooted
end

local function updateData(dt)
	if (car.index ~= 0 and sim.isOnlineRace) or sim.isReplayActive then
		ext_car.isIgnitionOn = true
		ext_car.isElectronicsBooted = true
	end

	delaySlowest = delaySlowest + dt
	if delaySlowest > slowestRefreshPeriod then
		slowestRefreshData(dt)
	end

	delaySlow = delaySlow + dt
	if delaySlow > slowRefreshPeriod then
		slowRefreshData(dt)
	end

	delayFast = delayFast + dt
	if delayFast > fastRefreshPeriod then
		fastRefreshData(dt)
	end

	fastestRefreshData(dt)
end

function ac.getFormattedData(dt)
	updateData(dt)
	return fdata
end
