local carp = ac.getCarPhysics(car.index)

local tyresINI = ac.INIConfig.carData(car.index, "tyres.ini")

function getTyreCarcassTemp(wheel)
	return carp.wheels[wheel].tyreCarcassTemperature
end

function getTyrePracticalTemp(fdata, wheel)
	return (1 - fdata.practicalTempRatio) * carp.wheels[wheel].tyreCarcassTemperature
		+ (
			fdata.practicalTempRatio
			* (car.wheels[wheel].tyreInsideTemperature + car.wheels[wheel].tyreMiddleTemperature + car.wheels[wheel].tyreOutsideTemperature)
			/ 3
		)
end

function getPracticalTempRatio()
	return tyresINI:get("_EXTENSION", "PRACTICAL_TEMP_RATIO", 0.4)
end

function getLeaderboard()
	local leaderboard = {}
	for i = 0, sim.carsCount - 1 do
		local car = ac.getCar(i)
		leaderboard[i + 1] = car
	end

	if sim.raceSessionType == 3 then
		table.sort(leaderboard, function(a, b)
			return (a.splinePosition + a.lapCount) > (b.splinePosition + b.lapCount)
		end)
	else
		table.sort(leaderboard, function(a, b)
			return a.bestLapTimeMs > b.bestLapTimeMs
		end)
	end

	return leaderboard
end

function getLeaderboardPosition(carIndex)
	local leaderboard = getLeaderboard()
	for position = 1, #leaderboard do
		if carIndex == leaderboard[position].index then
			return position
		end
	end
end

function getCarAheadIndex(carIndex)
	local leaderboard = getLeaderboard()
	for position = 1, #leaderboard do
		if carIndex == leaderboard[position].index then
			if position ~= 1 then
				return leaderboard[position - 1].index
			end
		end
	end
end
