if car.isAIControlled then
	return nil
end

ac.log("Lights")

local ext_car = ac.connect({
	ac.StructItem.key(ac.getCarID(car.index) .. "_ext_car_" .. car.index),
	connected = ac.StructItem.boolean(),
	oilTemperature = ac.StructItem.float(),
	antirollBarFrontPosition = ac.StructItem.int16(),
	antirollBarRearPosition = ac.StructItem.int16(),
	brakeBiasPosition = ac.StructItem.int16(),
	isIgnitionOn = ac.StructItem.boolean(),
	isElectronicsBooted = ac.StructItem.boolean(),
	isStarterCranking = ac.StructItem.boolean(),
	isEngineStarted = ac.StructItem.boolean(),
	isEngineRunning = ac.StructItem.boolean(),
}, true, ac.SharedNamespace.CarScript)

local LIGHTS_CONTROLLER = function()
	local digitalInstrumentsVisible = false

	local digitalInstrumentItems = {
		ac.findNodes("carRoot:" .. car.index):findAny("ITEM_7"),
		ac.findNodes("carRoot:" .. car.index):findAny("ITEM_8"),
	}

	local function setDigitalInstrumentsVisible(visible)
		digitalInstrumentsVisible = visible
		for _i, item in pairs(digitalInstrumentItems) do
			item:setVisible(visible)
		end
	end

	setDigitalInstrumentsVisible(false)

	return function()
		if ext_car.isElectronicsBooted and not digitalInstrumentsVisible then
			setDigitalInstrumentsVisible(true)
		elseif not ext_car.isElectronicsBooted and digitalInstrumentsVisible then
			setDigitalInstrumentsVisible(false)
		end
	end
end

local lightsController = LIGHTS_CONTROLLER()

function script.update(dt)
	lightsController()
end
