if car.isAIControlled then
	return nil
end

ac.log("Animations")

local applyLag = math.applyLag
local round = math.round

local carParamsINI = ac.INIConfig.carData(car.index, "car_params.ini")

local ext_car = ac.connect({
	ac.StructItem.key(ac.getCarID(car.index) .. "_ext_car_" .. car.index),
	connected = ac.StructItem.boolean(),
	oilTemperature = ac.StructItem.float(),
	antirollBarFrontPosition = ac.StructItem.int16(),
	antirollBarRearPosition = ac.StructItem.int16(),
	brakeBiasPosition = ac.StructItem.int16(),
	isIgnitionOn = ac.StructItem.boolean(),
	isElectronicsBooted = ac.StructItem.boolean(),
	isStarterCranking = ac.StructItem.boolean(),
	isEngineStarted = ac.StructItem.boolean(),
	isEngineRunning = ac.StructItem.boolean(),
}, true, ac.SharedNamespace.CarScript)

local LEVER_ANIMATION = function(node, positionKey, positionCount, rotationAxis, rotationInitial, rotationStep, lag)
	local animationNode = ac.findNodes("carRoot:" .. car.index):findAny(node)
	local animationPositionKey = positionKey
	local animationPositions = {}
	local animationRotationAxis = rotationAxis
	local animationRotation = rotationInitial
	local animationLag = lag

	for i = -positionCount, positionCount do
		animationPositions[i] = animationRotation
		animationRotation = animationRotation - rotationStep
	end

	local lastAnimationPosition = 0
	local currentAnimationPosition = animationPositions[0]
	local setAnimationPosition = 0
	local playAnimation = true

	return function(dt)
		setAnimationPosition = ext_car[animationPositionKey]

		if setAnimationPosition ~= lastAnimationPosition then
			playAnimation = true
		end

		if not playAnimation then
			return
		end

		currentAnimationPosition =
			applyLag(currentAnimationPosition, animationPositions[setAnimationPosition], animationLag, dt)
		animationNode:setRotation(animationRotationAxis, currentAnimationPosition)

		if round(currentAnimationPosition, 3) == round(animationPositions[setAnimationPosition], 3) then
			lastAnimationPosition = setAnimationPosition
			playAnimation = false
		end
	end
end

local function ANIMATION_CONTROLLER()
	local antirollBarFront = LEVER_ANIMATION(
		"ARB_FRONT",
		"antirollBarFrontPosition",
		carParamsINI:get("SUSPENSION", "ARB_STEP", 6),
		vec3(1, 0, 0),
		2.1,
		0.09,
		0.8
	)

	local antirollBarRear = LEVER_ANIMATION(
		"ARB_REAR",
		"antirollBarRearPosition",
		carParamsINI:get("SUSPENSION", "ARB_STEP", 6),
		vec3(1, 0, 0),
		2.1,
		0.09,
		0.8
	)

	local brakeBias = LEVER_ANIMATION("ARB_A", "brakeBiasPosition", 8, vec3(1, 0, 0), 1, -0.05, 0.8)

	return function(dt)
		antirollBarFront(dt)
		antirollBarRear(dt)
		brakeBias(dt)
	end
end

local animationController = ANIMATION_CONTROLLER()

function script.update(dt)
	animationController(dt)
end
