package.add("src")
require("data")
require("pages")
local fdata = ac.getFormattedData(0)

local override = nil

local backLightMesh = ac.findNodes("carRoot:" .. car.index):findMeshes("DISPLAY")

local backLightDiffuseOff = 0.5
local backLightDiffuseNight = 0.4

local brightnessOff = 0
local brightnessNight = 2

local backLightEmissiveOff = vec3(brightnessOff, brightnessOff, brightnessOff)
local backLightEmissiveOn = vec3(0, brightnessNight * 1.2, brightnessNight * 1.9)

local backLightDiffuse = backLightDiffuseOff
local backLightEmissive = backLightEmissiveOff

backLightMesh:setMaterialProperty("ksDiffuse", backLightDiffuse)
backLightMesh:setMaterialProperty("ksAmbient", backLightDiffuse)
backLightMesh:setMaterialProperty("ksEmissive", backLightEmissive)

local function updateDisplayBrightness()
	local brightnessUpdated = false

	if not fdata.isIgnitionOn then
		if backLightDiffuse ~= backLightDiffuseOff then
			brightnessUpdated = true
			backLightDiffuse = backLightDiffuseOff
			backLightEmissive = backLightEmissiveOff
		end
	elseif car.headlightsActive and backLightDiffuse ~= brightnessNight then
		brightnessUpdated = true
		backLightDiffuse = backLightDiffuseNight
		backLightEmissive = backLightEmissiveOn
	elseif not car.headlightsActive and backLightDiffuse == backLightDiffuseNight then
		brightnessUpdated = true
		backLightDiffuse = backLightDiffuseOff
		backLightEmissive = backLightEmissiveOff
	end

	if brightnessUpdated then
		backLightMesh:setMaterialProperty("ksAmbient", backLightDiffuse)
		backLightMesh:setMaterialProperty("ksDiffuse", backLightDiffuse)
		backLightMesh:setMaterialProperty("ksEmissive", backLightEmissive)
	end
end

local skipFrames = 0

function script.update(dt)
	local skipThisFrame = skipFrames > 0
	skipFrames = skipThisFrame and skipFrames - 1 or 1

	if skipThisFrame then
		ac.skipFrame()
		return
	end

	dt = dt * 3

	fdata = ac.getFormattedData(dt)
	updateDisplayBrightness()

	displayController(dt, fdata, override)
end
