local textColor = rgbm(0, 0, 0, 1)
local xOffset = 510
local yOffset = 514
local displayFont8Seg = "digital display tfb"
local displayFont14Seg = "DSEG14 Classic"

local xPosTopStart = 383
local digitsTop = {}
local dotsTop = {}

for i = 1, 4 do
	table.insert(digitsTop, vec2(xOffset - xPosTopStart + (94 * (i - 1)), yOffset + 158))
end

for i = 1, 3 do
	table.insert(dotsTop, vec2(xOffset - xPosTopStart + 41 + (94 * (i - 1)), yOffset + 158))
end

local xPosTopRightStart = -222
local digitsTopRight = {}
local dotsTopRight = {}

for i = 1, 3 do
	table.insert(digitsTopRight, vec2(xOffset - xPosTopRightStart + (62 * (i - 1)), yOffset + 182))
end

for i = 1, 2 do
	table.insert(dotsTopRight, vec2(xOffset - xPosTopRightStart + 31 + (62 * (i - 1)), yOffset + 182))
end

local xPosBottomRightStart = -222
local digitsBottomRight = {}
local dotsBottomRight = {}

for i = 1, 3 do
	table.insert(digitsBottomRight, vec2(xOffset - xPosBottomRightStart + (62 * (i - 1)), yOffset + 348))
end

for i = 1, 2 do
	table.insert(dotsBottomRight, vec2(xOffset - xPosBottomRightStart + 31 + (62 * (i - 1)), yOffset + 348))
end

local xPosLeftStart = 398
local digitsLeft = {}
local dotsLeft = {}

for i = 1, 3 do
	table.insert(digitsLeft, vec2(xOffset - xPosLeftStart + (62 * (i - 1)), yOffset + 348))
end

for i = 1, 2 do
	table.insert(dotsLeft, vec2(xOffset - xPosLeftStart + 30 + (62 * (i - 1)), yOffset + 348))
end

local xPosBottomStart = 168
local digitsBottom = {}
local dotsBottom = {}

for i = 1, 4 do
	table.insert(digitsBottom, vec2(xOffset - xPosBottomStart + (83 * (i - 1)), yOffset + 336))
end

for i = 1, 3 do
	table.insert(dotsBottom, vec2(xOffset - xPosBottomStart + 41 + (83 * (i - 1)), yOffset + 336))
end

local digitsMargin = vec2(200, 200)

local DIGIT_SECTION = function(digitFont, digitPositions, decimalPositions, fontSize, margin, color)
	local digitPositions = digitPositions
	local decimalPositions = decimalPositions
	local digitCount = #digitPositions
	local decimalCount = #decimalPositions
	local fontSize = fontSize
	local margin = margin
	local color = color
	local font = digitFont
	local buffer = "0"

	return function(digitValues, decimal, digitOffset, isTime, isString, clamp)
		ui.pushDWriteFont(font)

		local digitEnd = digitCount
		if clamp then
			digitEnd = clamp
		end

		if not decimal then
			decimal = 0
		end

		if not digitOffset then
			digitOffset = 0
		end

		if #digitValues <= 1 then
			if not digitValues[1] then
				digitValues[1] = 0
			end

			if decimal and decimal > 0 then
				table.insert(digitValues, 1, "0")
			end
		end

		if #digitValues > digitCount then
			decimal = decimal - math.min(#digitValues - digitCount, decimal)

			if isTime then
				ui.setCursor(decimalPositions[1])
				ui.dwriteTextAligned(":", fontSize, ui.Alignment.Center, ui.Alignment.Center, margin, false, color)
			end
		elseif #digitValues < digitEnd and isTime and not clamp then
			for i = 1, math.min(digitEnd - #digitValues, 2) do
				table.insert(digitValues, 1, buffer)
			end
		end

		if decimal > 0 then
			local offset = math.min(decimalCount - decimal + 1, decimalCount)
			ui.setCursor(decimalPositions[offset])
			ui.dwriteTextAligned(".", fontSize, ui.Alignment.Center, ui.Alignment.Center, margin, false, color)

			if isTime and clamp and digitCount > 4 then
				ui.setCursor(decimalPositions[offset - 2])

				ui.dwriteTextAligned(".", fontSize, ui.Alignment.Center, ui.Alignment.Center, margin, false, color)
			end
		end

		for i = 1, digitEnd do
			if digitValues[i] then
				local offset = digitCount - math.min(#digitValues + digitOffset, digitEnd)
				local text = digitValues[i]

				if not isString then
					text = text % 10
				end

				ui.setCursor(digitPositions[i + offset])
				ui.dwriteTextAligned(
					digitValues[i] % 10,
					fontSize,
					ui.Alignment.Center,
					ui.Alignment.Center,
					margin,
					false,
					color
				)
			end
		end

		ui.popDWriteFont()
	end
end

local digitSectionLeft = DIGIT_SECTION(displayFont8Seg, digitsLeft, dotsLeft, 120, digitsMargin, textColor)
local digitSectionTopRight = DIGIT_SECTION(displayFont8Seg, digitsTopRight, dotsTopRight, 120, digitsMargin, textColor)
local digitSectionBottomRight =
	DIGIT_SECTION(displayFont8Seg, digitsBottomRight, dotsBottomRight, 120, digitsMargin, textColor)

local digitSectionBottom = DIGIT_SECTION(displayFont8Seg, digitsBottom, dotsBottom, 163, digitsMargin, textColor)
local digitSectionTop = DIGIT_SECTION(displayFont14Seg, digitsTop, dotsTop, 113, vec2(200, 200), textColor)

function drawTopInfo(text)
	local text = string.pad(text, 4, " ", 1)

	digitSectionTop(text, 0, 0, false, true)
end

function drawOilPressure(dt, fdata)
	local oilPressureAdjusted = math.round(fdata.oilPressure)

	local digits = {}
	local oilPressure = math.clamp(oilPressureAdjusted, 0, 1999)
	while oilPressure > 0 do
		table.insert(digits, 1, math.round(oilPressure % 10))
		oilPressure = math.floor(oilPressure / 10)
	end

	digitSectionTopRight(digits, 1)
end

function drawFuelPressure(dt, fdata)
	local fuelPressure = math.round(fdata.fuelPressure * 10)

	local digits = {}
	local fuelPressure = math.clamp(fuelPressure, 0, 9999)
	while fuelPressure > 0 do
		table.insert(digits, 1, math.round(fuelPressure % 10))
		fuelPressure = math.floor(fuelPressure / 10)
	end

	digitSectionTop(digits, 1)
end

function drawSpeed(dt, fdata)
	local speed = math.round(fdata.speedKmh)

	local digits = {}
	local speed = math.clamp(speed, 0, 9999)
	while speed > 0 do
		table.insert(digits, 1, math.round(speed % 10))
		speed = math.floor(speed / 10)
	end

	digitSectionTop(digits, 0)
end

function drawLap(dt, fdata)
	local lapCount = fdata.lapCount

	local digits = {}
	local lapCount = math.clamp(lapCount, 0, 999)
	while lapCount > 0 do
		table.insert(digits, 1, math.round(lapCount % 10))
		lapCount = math.floor(lapCount / 10)
	end

	digitSectionLeft(digits, 0, 0)
end

function drawLapTime(dt, fdata)
	local lapTimeMs = fdata.lapTimeMs

	local seconds = (lapTimeMs / 1000) % 60 * 100
	local minutes = (lapTimeMs / (1000 * 60)) % 60

	local digits = {}
	local seconds = math.clamp(seconds, 0, 99999)
	while seconds > 0 do
		table.insert(digits, 1, math.round(seconds % 10))
		seconds = math.floor(seconds / 10)
	end

	if minutes > 1 then
		if minutes < 9.999 then
			if #digits <= 4 then
				for _i = 1, 4 - #digits do
					table.insert(digits, 1, 0)
				end
			end
			table.insert(digits, 1, math.floor(minutes))
		else
			for i = 1, 5 do
				digits[i] = 9
			end
		end
	end

	digitSectionBottom(digits, 2, 0, true)
end

function drawLastLapTimeBottom(dt, fdata)
	local previousLapTimeMs = car.previousLapTimeMs

	local seconds = (previousLapTimeMs / 1000) % 60 * 100
	local minutes = (previousLapTimeMs / (1000 * 60)) % 60

	local digits = {}
	local seconds = math.clamp(seconds, 0, 99999)
	while seconds > 0 do
		table.insert(digits, 1, math.round(seconds % 10))
		seconds = math.floor(seconds / 10)
	end

	if minutes > 1 then
		if minutes < 9.999 then
			if #digits <= 4 then
				for _i = 1, 4 - #digits do
					table.insert(digits, 1, 0)
				end
			end
			table.insert(digits, 1, math.floor(minutes))
		else
			for i = 1, 5 do
				digits[i] = 9
			end
		end
	end

	digitSectionTop(digits, 2, 0, true, false, 7)
end

function drawBrakeBias(dt, fdata)
	local brakeBias = math.round(fdata.brakeBias)

	local digits = {}
	local brakeBias = math.clamp(brakeBias, 0, 999)
	while brakeBias > 0 do
		table.insert(digits, 1, math.round(brakeBias % 10))
		brakeBias = math.floor(brakeBias / 10)
	end

	digitSectionTopRight(digits, 1, 0)
end

function drawWaterTemp(dt, fdata)
	local waterTemperature = math.round(fdata.waterTemperature * 10)

	local digits = {}
	local waterTemperature = math.clamp(waterTemperature, 0, 999)
	while waterTemperature > 0 do
		table.insert(digits, 1, math.round(waterTemperature % 10))
		waterTemperature = math.floor(waterTemperature / 10)
	end

	digitSectionBottom(digits, 1, 0)
end

function drawOilTemp(dt, fdata)
	local oilTemperature = math.round(fdata.oilTemperature * 10)

	local digits = {}
	local oilTemperature = math.clamp(oilTemperature, 0, 999)
	while oilTemperature > 0 do
		table.insert(digits, 1, math.round(oilTemperature % 10))
		oilTemperature = math.floor(oilTemperature / 10)
	end

	digitSectionBottomRight(digits, 1, 0)
end

function drawAirTemp(dt, fdata)
	local ambientTemperature = math.round(fdata.ambientTemperature * 10)

	local digits = {}
	local ambientTemperature = math.clamp(ambientTemperature, 0, 999)
	while ambientTemperature > 0 do
		table.insert(digits, 1, math.round(ambientTemperature % 10))
		ambientTemperature = math.floor(ambientTemperature / 10)
	end

	digitSectionBottom(digits, 1, 0)
end

function drawRpm(dt, fdata)
	local rpm = math.round(fdata.rpm / 100)

	local digits = {}
	local rpm = math.clamp(rpm, 0, 199)
	while rpm > 0 do
		table.insert(digits, 1, math.min(math.round(rpm % 10), 9))
		rpm = math.floor(rpm / 10)
	end

	digitSectionLeft(digits, 1, 0)
end

function drawFuel(dt, fdata)
	local fuel = math.round(fdata.fuel)

	local digits = {}
	local fuel = math.clamp(fuel, 0, 199)
	while fuel > 0 do
		table.insert(digits, 1, math.round(fuel % 10))
		fuel = math.floor(fuel / 10)
	end

	digitSectionBottomRight(digits, 0, 0)
end

function drawValue(font, string, fontSize, xPos, yPos, xAlign, color, margin)
	ui.pushDWriteFont(font)
	if not margin then
		margin = vec2(350, 350)
	end
	if not color then
		color = rgbm(1, 1, 1, 0.7)
	end
	if not fontSize then
		fontSize = 70
	end

	ui.setCursorX(xPos)
	ui.setCursorY(yPos)
	ui.dwriteTextAligned(string, fontSize, xAlign, ui.Alignment.Center, margin, false, color)
	ui.popDWriteFont()
end

function drawDelta(dt, fdata)
	local isNegative = fdata.performanceMeter < 0

	local performanceMeter = math.round(math.abs(fdata.performanceMeter * 100))

	local digits = {}
	local performanceMeter = math.clamp(performanceMeter, 0, 9999)
	while performanceMeter > 0 do
		table.insert(digits, 1, math.round(performanceMeter % 10))
		performanceMeter = math.floor(performanceMeter / 10)
	end

	if #digits < 3 then
		while #digits < 3 do
			table.insert(digits, 1, "0")
		end
	end

	if isNegative then
		table.insert(digits, 1, "-")
	else
		table.insert(digits, 1, "+")
	end

	digitSectionTop(digits, 2, 0, false, false, 5)
end

function drawGear(dt, fdata)
	ui.pushDWriteFont(displayFont14Seg)

	ui.setCursorX(xOffset + 33)
	ui.setCursorY(yOffset + 158)
	ui.dwriteTextAligned(fdata.gear, 113, ui.Alignment.End, ui.Alignment.Center, vec2(200, 200), false, textColor)

	ui.popDWriteFont()
end

function drawBattery(dt, fdata)
	local battery = math.round(fdata.batteryVoltage * 10)

	local digits = {}
	local battery = math.clamp(battery, 0, 199)
	while battery > 0 do
		table.insert(digits, 1, math.round(battery % 10))
		battery = math.floor(battery / 10)
	end

	digitSectionLeft(digits, 1, 0)
end
