package.add("src")
require("instruments")

local sim = ac.getSim()

local stored = ac.storage({
	activeDisplay = 1,
	splashShown = false,
	initialized = false,
})

stored.splashShown = false
stored.initialized = false

local rpmBarImages = {}
local rpmBarImageSizes = {}

for i = 0, 65 do
	rpmBarImages[i] = ui.decodeImage(io.loadFromZip(ac.findFile("assets.zip"), "rpm_bar_" .. i .. ".png"))
	rpmBarImageSizes[i] = ui.imageSize(rpmBarImages[i])
end

local COMMON_INSTRUMENTS = function()
	local lastRpm = car.rpm
	local lastRpmBar = 0
	local timerRpmBar = 0

	return function(dt, fdata)
		local rpmMult = 250
		local rpmAdd = 0

		for i = 0, 65 do
			if i < 1 then
				rpmMult = 1000
			elseif i > 32 then
				rpmMult = 62.5
				rpmAdd = 5000
			elseif i > 15 then
				rpmMult = 125
				rpmAdd = 3000
			else
				rpmMult = 250
				rpmAdd = 1000
			end

			if fdata.rpm > i * rpmMult + rpmAdd then
				if fdata.rpm > lastRpm then
					lastRpmBar = i
				end
				display.image({
					image = rpmBarImages[i],
					pos = vec2(0, 0),
					size = rpmBarImageSizes[i],
					color = rgbm.colors.black,
					uvStart = vec2(0, 0),
					uvEnd = vec2(1, 1),
				})
			end
		end

		if fdata.rpm < lastRpm then
			timerRpmBar = os.clock() + 1
		end

		if timerRpmBar > os.clock() then
			display.image({
				image = rpmBarImages[lastRpmBar],
				pos = vec2(0, 0),
				size = rpmBarImageSizes[lastRpmBar],
				color = rgbm.colors.black,
				uvStart = vec2(0, 0),
				uvEnd = vec2(1, 1),
			})
		end

		lastRpm = fdata.rpm

		drawGear(dt, fdata)
	end
end

local commonInstruments = COMMON_INSTRUMENTS()

local dashImageRace = ui.decodeImage(io.loadFromZip(ac.findFile("assets.zip"), "8_seg_race.png"))
local dashImageRaceSize = ui.imageSize(dashImageRace)
local DASH_RACE_1 = function()
	return function(dt, fdata)
		display.image({ image = dashImageRace, pos = vec2(0, 0), size = dashImageRaceSize })
		commonInstruments(dt, fdata)

		drawWaterTemp(dt, fdata)
		drawLap(dt, fdata)
		drawBrakeBias(dt, fdata)
		drawFuel(dt, fdata)

		if not fdata.isInPitlane and fdata.isElectronicsBooted then
			drawFuelPressure(dt, fdata)
		end
	end
end

local dashImagePractice = ui.decodeImage(io.loadFromZip(ac.findFile("assets.zip"), "8_seg_practice.png"))
local dashImagePracticeSize = ui.imageSize(dashImagePractice)
local DASH_PRACTICE = function()
	return function(dt, fdata)
		display.image({ image = dashImagePractice, pos = vec2(0, 0), size = dashImagePracticeSize })
		commonInstruments(dt, fdata)

		drawRpm(dt, fdata)
		drawBrakeBias(dt, fdata)
		drawOilTemp(dt, fdata)
		drawLapTime(dt, fdata)

		if not fdata.isInPitlane and fdata.isElectronicsBooted then
			drawSpeed(dt, fdata)
		end
	end
end

local dashImageWarmup = ui.decodeImage(io.loadFromZip(ac.findFile("assets.zip"), "8_seg_warmup.png"))
local dashImageWarmupSize = ui.imageSize(dashImageWarmup)
local DASH_WARMUP = function()
	return function(dt, fdata)
		display.image({ image = dashImageWarmup, pos = vec2(0, 0), size = dashImageWarmupSize })
		commonInstruments(dt, fdata)

		drawBattery(dt, fdata)
		drawOilTemp(dt, fdata)
		drawAirTemp(dt, fdata)
		drawOilPressure(dt, fdata)

		if not fdata.isInPitlane and fdata.isElectronicsBooted then
			drawFuelPressure(dt, fdata)
		end
	end
end

local dashImageOff = ui.decodeImage(io.loadFromZip(ac.findFile("assets.zip"), "8_seg_off.png"))
local dashImageOffSize = ui.imageSize(dashImageOff)
local OFFLINE = function()
	return function(dt, fdata)
		display.image({ image = dashImageOff, pos = vec2(0, 0), size = dashImageOffSize })
	end
end

local SPLASH = function()
	return function(dt, fdata)
		drawTopInfo(" VRC")
	end
end

local PIT_LIMITER = function()
	return function(dt, fdata)
		drawTopInfo(" PIT")
	end
end

local pages = {
	DASH_RACE_1(),
	DASH_PRACTICE(),
	DASH_WARMUP(),
}

local popups = {
	OFFLINE(),
	SPLASH(),
	PIT_LIMITER(),
}
local pageController = function()
	local currentPage = 1

	local pageDownButton = ac.ControlButton("__EXT_LIGHT_E")
	local pageUpButton = ac.ControlButton("__EXT_LIGHT_F")

	pageDownButton:onPressed(function()
		if currentPage == 1 then
			currentPage = #pages
		else
			currentPage = currentPage - 1
		end

		stored.activeDisplay = currentPage
	end)

	pageUpButton:onPressed(function()
		if currentPage >= #pages then
			currentPage = 1
		else
			currentPage = currentPage + 1
		end

		stored.activeDisplay = currentPage
	end)

	return function(forcedMode)
		if forcedMode then
			return forcedMode
		end

		if car.isAIControlled then
			if sim.raceSessionType == ac.SessionType.Race then
				currentPage = 1
			else
				currentPage = 2
			end

			stored.activeDisplay = currentPage
			return currentPage
		end

		if not stored.initialized then
			stored.initialized = true
		end

		return currentPage
	end
end
local popupController = function()
	return function(fdata, page, forcedMode)
		if not fdata.isIgnitionOn then
			return 1
		elseif fdata.isIgnitionOn and not fdata.isElectronicsBooted then
			return 2
		elseif fdata.isInPitlane then
			return 3
		else
			return nil
		end
	end
end

local imagesLoaded = false
local function imagesInitialized()
	if not imagesLoaded then
		local loadedTest = true

		for i = 0, 65 do
			if not ui.isImageReady(rpmBarImages[i]) then
				loadedTest = false
			end
		end

		        if
            not ui.isImageReady(dashImageOff)
            or not ui.isImageReady(dashImageRace)
            or not  ui.isImageReady(dashImagePractice)
            or not ui.isImageReady(dashImageWarmup)
        then
            loadedTest = false
        end

		imagesLoaded = loadedTest

		return imagesLoaded
	else
		return true
	end
end

local getPage = pageController()
local getPopup = popupController()
function displayController(dt, fdata, forcedMode)
	if not imagesInitialized() then
		return
	end

	local page = getPage(forcedMode)

	pages[page](dt, fdata)

	local popup = getPopup(fdata, page, forcedMode)
	if popup then
		popups[popup](dt, fdata)
	end
end
